<?php
require_once F_ROOT . "includes/configure.php";

/**
 * Signature Class
 */
class App
{
	public function generatePdf($body, $pdfName)
	{

		if (!file_exists(F_PDF)) {
			mkdir(F_PDF, 0777, true);
		}

		$body = iconv("UTF-8", "UTF-8//IGNORE", $body);
		require_once F_ROOT . '/vendor/autoload.php';
		$mpdf = new \Mpdf\Mpdf([
			'default_font_size' => 7
		]);
//write html to PDF
		$stylesheet = file_get_contents('css/bootstrap.min.css');
		$stylesheet1 = file_get_contents('css/style.css');
		$stylesheet2 = file_get_contents('css/pdf.css');
//	$mpdf->WriteHTML($stylesheet,1);
		$mpdf->WriteHTML($stylesheet1, 1);
		$mpdf->WriteHTML($stylesheet2, 1);
		$mpdf->WriteHTML($body, 2);
//output pdf
		$mpdf->Output($pdfName, 'F');

		return $pdfName;
	}

	public function sendMail($fromEmail = '', $fromName = '', $toEmail = '', $replyToEmail = '', $subject = '', $message = '', $attachments = array())
	{
		require_once(LIB . "Mail.Class.php");
		$mail     = new Mail();
		$sendMail = $mail->sendMail($fromEmail, $fromName, $toEmail, $replyToEmail, $subject, $message, $attachments);
		if (!$sendMail['success']) {
			// TRY WITH PHP MAIL
			return $mail->sendPHPMail($fromEmail, $fromName, $toEmail, $replyToEmail, $subject, $message, $attachments);
		} else {
			return 1;
		}
	}

	public function sendPHPMail($fromEmail = '', $fromName = '', $toEmail = '', $replyToEmail = '', $subject = '', $message = '', $attachments = array())
	{
		require_once(LIB . "Mail.Class.php");
		$mail = new Mail();
		return $mail->sendPHPMail($fromEmail, $fromName, $toEmail, $replyToEmail, $subject, $message, $attachments);
	}

	public function deleteFile($filename)
	{

		chmod($filename, 0777);
		unlink($filename);

	}
}